/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.e.ElvishRefuelerWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ElvishRefuelerEffect
extends AsThoughEffectImpl {
    private final FilterPermanent filter;

    ElvishRefuelerEffect(FilterPermanent filter) {
        super(AsThoughEffectType.ALLOW_EXHAUST_PER_TURN, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.filter = filter;
        this.staticText = "During your turn, as long as you haven't activated an exhaust ability this turn, you may activate exhaust abilities as though they haven't been activated";
    }

    ElvishRefuelerEffect(ElvishRefuelerEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.filter = effect.filter;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ElvishRefuelerEffect copy() {
        return new ElvishRefuelerEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        ElvishRefuelerWatcher watcher = (ElvishRefuelerWatcher)game.getState().getWatcher(ElvishRefuelerWatcher.class);
        if (!game.isActivePlayer(affectedControllerId) || watcher == null || watcher.checkActivatedExhaust(affectedControllerId)) {
            return false;
        }
        Permanent permanent = game.getPermanent(objectId);
        return this.filter.match(permanent, source.getControllerId(), source, game);
    }
}

