/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class ElvishSoultillerEffect
extends OneShotEffect {
    ElvishSoultillerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature type. Shuffle all creature cards of that type from your graveyard into your library";
    }

    private ElvishSoultillerEffect(ElvishSoultillerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElvishSoultillerEffect copy() {
        return new ElvishSoultillerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceCreatureType typeChoice;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (controller != null && mageObject != null && controller.choose(this.outcome, (Choice)(typeChoice = new ChoiceCreatureType(game, source)), game)) {
            if (!game.isSimulation()) {
                game.informPlayers(mageObject.getName() + ": " + controller.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            }
            CardsImpl cardsToLibrary = new CardsImpl();
            FilterCreatureCard filter = new FilterCreatureCard();
            filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            cardsToLibrary.addAllCards((Collection)controller.getGraveyard().getCards((FilterCard)filter, source.getControllerId(), source, game));
            controller.putCardsOnTopOfLibrary((Cards)cardsToLibrary, game, source, false);
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

