/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EmberGaleEffect
extends OneShotEffect {
    EmberGaleEffect() {
        super(Outcome.Detriment);
        this.staticText = "Creatures target player controls can't block this turn. {this} deals 1 damage to each white and/or blue creature that player controls";
    }

    private EmberGaleEffect(EmberGaleEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmberGaleEffect copy() {
        return new EmberGaleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
            CantBlockAllEffect effect = new CantBlockAllEffect(filter, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect, source);
            FilterPermanent filter2 = new FilterPermanent();
            filter2.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
            filter2.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.WHITE), (Predicate)new ColorPredicate(ObjectColor.BLUE)));
            filter2.add((Predicate)CardType.CREATURE.getPredicate());
            for (Permanent creature : game.getBattlefield().getAllActivePermanents(filter2, targetPlayer.getId(), game)) {
                creature.damage(1, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

