/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class EmbermouthSentinelEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.DRAGON);

    EmbermouthSentinelEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a basic land card, reveal it, then shuffle and put that card on top. If you control a Dragon, put that card onto the battlefield tapped instead";
    }

    private EmbermouthSentinelEffect(EmbermouthSentinelEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmbermouthSentinelEffect copy() {
        return new EmbermouthSentinelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        player.shuffleLibrary(source, game);
        if (card == null) {
            return true;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (game.getBattlefield().contains(filter, source, game, 1)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        } else {
            player.putCardsOnTopOfLibrary(card, game, source, false);
        }
        return true;
    }
}

