/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class EmbersmithEffect
extends OneShotEffect {
    EmbersmithEffect() {
        super(Outcome.Damage);
        this.staticText = "you may pay {1}. If you do, {this} deals 1 damage to any target";
    }

    private EmbersmithEffect(EmbersmithEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ManaCost cost = ManaUtil.createManaCost((int)1, (boolean)false);
        if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
            Permanent permanent = game.getPermanent(source.getFirstTarget());
            if (permanent != null) {
                permanent.damage(1, source.getSourceId(), source, game, false, true);
                return true;
            }
            Player player = game.getPlayer(source.getFirstTarget());
            if (player != null) {
                player.damage(1, source.getSourceId(), source, game);
                return true;
            }
            return false;
        }
        return false;
    }

    public EmbersmithEffect copy() {
        return new EmbersmithEffect(this);
    }
}

