/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Arrays;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EmbiggenEffect
extends OneShotEffect {
    EmbiggenEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, target non-Brushwagg creature gets +1/+1 for each supertype, card type, and subtype it has";
    }

    private EmbiggenEffect(EmbiggenEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmbiggenEffect copy() {
        return new EmbiggenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int count = permanent.getSuperType(game).size() + permanent.getCardType(game).size() + Arrays.stream(SubType.values()).filter(subType -> permanent.hasSubtype(subType, game)).mapToInt(x -> 1).sum();
        if (count > 0) {
            game.addEffect(new BoostTargetEffect(count, count).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            return true;
        }
        return false;
    }
}

