/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.EmetSelchOfTheThirdSeatEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.LifeLostBatchEvent;
import mage.game.events.LifeLostEvent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class EmetSelchOfTheThirdSeatAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<LifeLostEvent> {
    EmetSelchOfTheThirdSeatAbility() {
        super(Zone.BATTLEFIELD, (Effect)new EmetSelchOfTheThirdSeatEffect());
        this.setTriggerPhrase("Whenever one or more opponents lose life, ");
        this.addTarget((Target)new TargetCardInYourGraveyard(StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY_FROM_YOUR_GRAVEYARD));
        this.setDoOnlyOnceEachTurn(true);
    }

    private EmetSelchOfTheThirdSeatAbility(EmetSelchOfTheThirdSeatAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_LIFE_BATCH;
    }

    public boolean checkEvent(LifeLostEvent event, Game game) {
        return game.getOpponents(this.getControllerId()).contains(event.getTargetId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List filteredEvents = this.getFilteredEvents((BatchEvent)((LifeLostBatchEvent)event), game);
        return !filteredEvents.isEmpty() && CardUtil.getEventTargets((GameEvent)event).stream().anyMatch(uuid -> LifeLostBatchEvent.getLifeLostByPlayer((Collection)filteredEvents, (UUID)uuid) > 0);
    }

    public EmetSelchOfTheThirdSeatAbility copy() {
        return new EmetSelchOfTheThirdSeatAbility(this);
    }
}

