/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseSecretOpponentEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;

class EmissaryOfGrudgesEffect
extends OneShotEffect {
    EmissaryOfGrudgesEffect() {
        super(Outcome.Neutral);
        this.staticText = "Choose new targets for target spell or ability if it's controlled by the chosen player and if it targets you or a permanent you control. Activate only once.";
    }

    private EmissaryOfGrudgesEffect(EmissaryOfGrudgesEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmissaryOfGrudgesEffect copy() {
        return new EmissaryOfGrudgesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        StackObject stackObject = game.getStack().getStackObject(source.getFirstTarget());
        if (controller == null || stackObject == null || !stackObject.isControlledBy(ChooseSecretOpponentEffect.getChosenPlayer((Ability)source, (Game)game))) {
            return false;
        }
        boolean targetsYouOrAPermanentYouControl = false;
        for (UUID modeId : stackObject.getStackAbility().getModes().getSelectedModes()) {
            Mode mode = stackObject.getStackAbility().getModes().get((Object)modeId);
            for (Target target : mode.getTargets()) {
                for (UUID targetId : target.getTargets()) {
                    Permanent permanent;
                    if (source.isControlledBy(targetId)) {
                        targetsYouOrAPermanentYouControl = true;
                    }
                    if ((permanent = game.getPermanent(targetId)) == null || !source.isControlledBy(permanent.getControllerId())) continue;
                    targetsYouOrAPermanentYouControl = true;
                }
            }
        }
        if (targetsYouOrAPermanentYouControl) {
            return stackObject.chooseNewTargets(game, source.getControllerId(), false, false, null);
        }
        return false;
    }
}

