/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class EmissaryOfHopeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("artifact");

    EmissaryOfHopeEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain 1 life for each artifact that player controls";
    }

    private EmissaryOfHopeEffect(EmissaryOfHopeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && sourcePlayer != null) {
            int amount = game.getBattlefield().count(filter, targetPlayer.getId(), source, game);
            if (amount > 0) {
                sourcePlayer.gainLife(amount, game, source);
            }
            return true;
        }
        return false;
    }

    public EmissaryOfHopeEffect copy() {
        return new EmissaryOfHopeEffect(this);
    }

    static {
        filter.add((Predicate)CardType.ARTIFACT.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

