/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EmpoweredAutogeneratorManaEffect
extends ManaEffect {
    private final Mana computedMana;

    EmpoweredAutogeneratorManaEffect() {
        this.computedMana = new Mana();
        this.staticText = "Put a charge counter on {this}. Add X mana of any one color, where X is the number of charge counters on {this}";
    }

    private EmpoweredAutogeneratorManaEffect(EmpoweredAutogeneratorManaEffect effect) {
        super((ManaEffect)effect);
        this.computedMana = effect.computedMana.copy();
    }

    public EmpoweredAutogeneratorManaEffect copy() {
        return new EmpoweredAutogeneratorManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        int counters;
        Permanent sourcePermanent;
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null && (sourcePermanent = game.getPermanent(source.getSourceId())) != null && (counters = sourcePermanent.getCounters(game).getCount(CounterType.CHARGE) + 1) > 0) {
            netMana.add(Mana.AnyMana((int)counters));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        String color;
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        game.processAction();
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return mana;
        }
        sourcePermanent.addCounters(CounterType.CHARGE.createInstance(), source.getControllerId(), source, game);
        int counters = sourcePermanent.getCounters(game).getCount(CounterType.CHARGE);
        if (counters == 0) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return mana;
        }
        ChoiceColor choice = new ChoiceColor();
        choice.setMessage("Choose a color to add mana of that color");
        if (!controller.choose(this.outcome, (Choice)choice, game)) {
            return mana;
        }
        if (choice.getChoice() == null) {
            return mana;
        }
        switch (color = choice.getChoice()) {
            case "Red": {
                mana.setRed(counters);
                break;
            }
            case "Blue": {
                mana.setBlue(counters);
                break;
            }
            case "White": {
                mana.setWhite(counters);
                break;
            }
            case "Black": {
                mana.setBlack(counters);
                break;
            }
            case "Green": {
                mana.setGreen(counters);
            }
        }
        return mana;
    }
}

