/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class EmryLurkerOfTheLochPlayEffect
extends AsThoughEffectImpl {
    EmryLurkerOfTheLochPlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Choose target artifact card in your graveyard. You may cast that card this turn.";
    }

    private EmryLurkerOfTheLochPlayEffect(EmryLurkerOfTheLochPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public EmryLurkerOfTheLochPlayEffect copy() {
        return new EmryLurkerOfTheLochPlayEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        if (targetId == null) {
            this.discard();
            return false;
        }
        return targetId.equals(objectId) && source.isControlledBy(affectedControllerId) && Zone.GRAVEYARD == game.getState().getZone(objectId) && !game.getCard(targetId).isLand(game);
    }
}

