/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum EndlessAtlasCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        HashMap<String, Integer> landMap = new HashMap<String, Integer>();
        for (Permanent land : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), game)) {
            if (land == null) continue;
            int landCount = landMap.getOrDefault(land.getName(), 0);
            if (landCount > 1) {
                return true;
            }
            landMap.put(land.getName(), landCount + 1);
        }
        return false;
    }

    public String toString() {
        return "you control three or more lands with the same name";
    }
}

