/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class EndlessSandsEffect
extends OneShotEffect {
    EndlessSandsEffect() {
        super(Outcome.Benefit);
        this.staticText = "return each creature card exiled with {this} to the battlefield under its owner's control";
    }

    private EndlessSandsEffect(EndlessSandsEffect effect) {
        super((OneShotEffect)effect);
    }

    public EndlessSandsEffect copy() {
        return new EndlessSandsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        return player != null && exileZone != null && player.moveCards(exileZone.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
    }
}

