/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EnduringAngelEffect
extends ReplacementEffectImpl {
    EnduringAngelEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if your life total would be reduced to 0 or less, instead transform {this} and your life total becomes 3. Then if {this} didn't transform this way, you lose the game";
    }

    private EnduringAngelEffect(EnduringAngelEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null || player.getLife() - event.getAmount() > 0) {
            return false;
        }
        boolean transformed = permanent.transform(source, game);
        if (player.getLife() > 3) {
            event.setAmount(player.getLife() - 3);
        } else if (player.getLife() < 3) {
            event.setAmount(0);
            player.setLife(3, game, source);
        } else {
            event.setAmount(0);
        }
        if (!transformed) {
            player.lost(game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOSE_LIFE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public EnduringAngelEffect copy() {
        return new EnduringAngelEffect(this);
    }
}

