/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class EnduringRenewalReplacementEffect
extends ReplacementEffectImpl {
    EnduringRenewalReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card, reveal the top card of your library instead. If it's a creature card, put it into your graveyard. Otherwise, draw a card";
    }

    private EnduringRenewalReplacementEffect(EnduringRenewalReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public EnduringRenewalReplacementEffect copy() {
        return new EnduringRenewalReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(card);
        controller.revealCards("Top card of " + controller.getName() + "'s library", (Cards)cards, game);
        if (card.isCreature(game)) {
            controller.moveCards(card, Zone.GRAVEYARD, source, game);
        } else {
            controller.drawCards(1, source, game, event);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

