/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class EnergyVortexEffect
extends OneShotEffect {
    EnergyVortexEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to that player unless they pay {1} for each vortex counter on {this}";
    }

    private EnergyVortexEffect(EnergyVortexEffect effect) {
        super((OneShotEffect)effect);
    }

    public EnergyVortexEffect copy() {
        return new EnergyVortexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        int counters = permanent.getCounters(game).getCount(CounterType.VORTEX);
        ManaCost cost = ManaUtil.createManaCost((int)counters, (boolean)false);
        return cost.pay(source, game, source, player.getId(), false) || player.damage(3, source.getSourceId(), source, game) > 0;
    }
}

