/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EngulfingSlagwurmEffect
extends OneShotEffect {
    EngulfingSlagwurmEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to that creature's toughness";
    }

    private EngulfingSlagwurmEffect(EngulfingSlagwurmEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (creature != null && controller != null) {
            controller.gainLife(creature.getToughness().getValue(), game, source);
        }
        return false;
    }

    public EngulfingSlagwurmEffect copy() {
        return new EngulfingSlagwurmEffect(this);
    }
}

