/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EnsnaringBridgeRestrictionEffect
extends RestrictionEffect {
    EnsnaringBridgeRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures with power greater than the number of cards in your hand can't attack";
    }

    private EnsnaringBridgeRestrictionEffect(EnsnaringBridgeRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        return game.getState().getPlayersInRange(controller.getId(), game).contains((Object)permanent.getControllerId()) && permanent.getPower().getValue() > controller.getHand().size();
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public EnsnaringBridgeRestrictionEffect copy() {
        return new EnsnaringBridgeRestrictionEffect(this);
    }
}

