/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

class EonFrolickerEffect
extends OneShotEffect {
    EonFrolickerEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent takes an extra turn after this one. Until your next turn, you and planeswalkers you control gain protection from that player";
    }

    private EonFrolickerEffect(EonFrolickerEffect effect) {
        super((OneShotEffect)effect);
    }

    public EonFrolickerEffect copy() {
        return new EonFrolickerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        game.getState().getTurnMods().add(new TurnMod(player.getId()).withExtraTurn());
        FilterPlayer filter = new FilterPlayer(player.getName());
        filter.add((Predicate)new PlayerIdPredicate(player.getId()));
        ProtectionAbility ability = new ProtectionAbility((Filter)filter);
        game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)ability, Duration.UntilYourNextTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_PLANESWALKER), source);
        game.addEffect((ContinuousEffect)new GainAbilityControllerEffect((Ability)ability, Duration.UntilYourNextTurn), source);
        return true;
    }
}

