/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.condition.common.ThresholdCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EpicenterEffect
extends OneShotEffect {
    EpicenterEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "<br>" + AbilityWord.THRESHOLD.formatWord() + "Each player sacrifices all lands they control instead if seven or more cards are in your graveyard.";
    }

    private EpicenterEffect(EpicenterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        if (!ThresholdCondition.instance.apply(game, source)) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game)) {
            permanent.sacrifice(source, game);
        }
        return true;
    }

    public EpicenterEffect copy() {
        return new EpicenterEffect(this);
    }
}

