/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class ErrandRiderOfGondorEffect
extends OneShotEffect {
    ErrandRiderOfGondorEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card. Then if you don't control a legendary creature, put a card from your hand on the bottom of your library";
    }

    private ErrandRiderOfGondorEffect(ErrandRiderOfGondorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ErrandRiderOfGondorEffect copy() {
        return new ErrandRiderOfGondorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        if (game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_LEGENDARY, source, game, 1) || player.getHand().isEmpty()) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand();
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card == null || player.putCardsOnBottomOfLibrary(card, game, source);
    }
}

