/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class ErraticCyclopsTriggeredAbility
extends TriggeredAbilityImpl {
    public ErraticCyclopsTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private ErraticCyclopsTriggeredAbility(ErraticCyclopsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.isControlledBy(this.controllerId) && spell.isInstantOrSorcery(game)) {
            this.getEffects().clear();
            this.addEffect((Effect)new BoostSourceEffect(spell.getManaValue(), 0, Duration.EndOfTurn));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell, {this} gets +X/+0 until end of turn, where X is that spell's mana value.";
    }

    public ErraticCyclopsTriggeredAbility copy() {
        return new ErraticCyclopsTriggeredAbility(this);
    }
}

