/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class EruthTormentedProphetEffect
extends ReplacementEffectImpl {
    EruthTormentedProphetEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you would draw a card, exile the top two cards of your library instead. You may play those cards this turn";
    }

    private EruthTormentedProphetEffect(EruthTormentedProphetEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public EruthTormentedProphetEffect copy() {
        return new EruthTormentedProphetEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player == null) {
            return true;
        }
        Set cards = player.getLibrary().getTopCards(game, 2);
        player.moveCards(cards, Zone.EXILED, source, game);
        for (Card card : cards) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

