/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class EsperSentinelEffect
extends OneShotEffect {
    EsperSentinelEffect() {
        super(Outcome.DrawCard);
    }

    private EsperSentinelEffect(EsperSentinelEffect effect) {
        super((OneShotEffect)effect);
    }

    public EsperSentinelEffect copy() {
        return new EsperSentinelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && opponent != null && permanent != null) {
            ManaCost cost = ManaUtil.createManaCost((int)permanent.getPower().getValue(), (boolean)false);
            if (!opponent.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + "?", source, game) || !cost.pay(source, game, source, opponent.getId(), false)) {
                controller.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }
}

