/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Iterator;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.EsperSentinelEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.SpellsCastWatcher;

class EsperSentinelTriggeredAbility
extends TriggeredAbilityImpl {
    public EsperSentinelTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new EsperSentinelEffect());
    }

    private EsperSentinelTriggeredAbility(EsperSentinelTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EsperSentinelTriggeredAbility copy() {
        return new EsperSentinelTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        Spell spell = game.getSpell(event.getTargetId());
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (controller != null && spell != null && watcher != null && !spell.isCreature(game) && controller.hasOpponent(spell.getControllerId(), game)) {
            Spell spellCastThisTurn;
            int nonCreatureSpells = 0;
            Iterator iterator = watcher.getSpellsCastThisTurn(spell.getControllerId()).iterator();
            while (iterator.hasNext() && ((spellCastThisTurn = (Spell)iterator.next()).isCreature(game) || ++nonCreatureSpells <= 1)) {
            }
            if (nonCreatureSpells == 1) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(spell.getControllerId()));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent casts their first noncreature spell each turn, draw a card unless that player pays {X}, where X is {this}'s power.";
    }
}

