/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.cards.e.EspersToMagiciteTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class EspersToMagiciteExileEffect
extends OneShotEffect {
    EspersToMagiciteExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile each opponent's graveyard. When you do, choose up to one target creature card exiled this way. Create a token that's a copy of that card, except it's an artifact and it loses all other card types";
    }

    private EspersToMagiciteExileEffect(EspersToMagiciteExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public EspersToMagiciteExileEffect copy() {
        return new EspersToMagiciteExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            cards.addAll((Collection)opponent.getGraveyard());
        }
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new EspersToMagiciteTokenEffect(), false);
        ability.addTarget((Target)new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, CardUtil.getExileZoneId((Game)game, (Ability)source)));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

