/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EssenceFilterEffect
extends OneShotEffect {
    private static final FilterEnchantmentPermanent filter = new FilterEnchantmentPermanent("nonwhite enchantments");

    public EssenceFilterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy all enchantments or all nonwhite enchantments";
    }

    private EssenceFilterEffect(EssenceFilterEffect effect) {
        super((OneShotEffect)effect);
    }

    public EssenceFilterEffect copy() {
        return new EssenceFilterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.chooseUse(this.outcome, "Destroy all enchantments? (otherwise all nonwhite enchantments are destroyed)", source, game)) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterEnchantmentPermanent(), controller.getId(), source, game)) {
                    permanent.destroy(source, game, false);
                }
            } else {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, controller.getId(), source, game)) {
                    permanent.destroy(source, game, false);
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)new ColorPredicate(ObjectColor.WHITE)));
    }
}

