/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EssenceReliquaryTargetEffect
extends OneShotEffect {
    EssenceReliquaryTargetEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return another target permanent you control and all Auras you control attached to it to their owner's hand";
    }

    private EssenceReliquaryTargetEffect(EssenceReliquaryTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public EssenceReliquaryTargetEffect copy() {
        return new EssenceReliquaryTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Card)permanent);
        cards.addAll((Collection)permanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(p -> p.isControlledBy(source.getControllerId())).filter(p -> p.hasSubtype(SubType.AURA, game)).map(MageItem::getId).collect(Collectors.toList()));
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }
}

