/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.e.EtchedSlithEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterOpponent;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetPermanentOrPlayer;

class EtchedSlithPutWhenDoEffect
extends OneShotEffect {
    private static final FilterPermanent filterPermanent = new FilterPermanent();
    private static final FilterPermanentOrPlayer filter;

    EtchedSlithPutWhenDoEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on it. When you do, you may remove a counter from another target permanent or opponent";
    }

    private EtchedSlithPutWhenDoEffect(EtchedSlithPutWhenDoEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtchedSlithPutWhenDoEffect copy() {
        return new EtchedSlithPutWhenDoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        int beforeP1P1 = permanent.getCounters(game).getCount(CounterType.P1P1);
        new AddCountersSourceEffect(CounterType.P1P1.createInstance()).apply(game, source);
        game.processAction();
        int afterP1P1 = permanent.getCounters(game).getCount(CounterType.P1P1);
        for (int i = beforeP1P1 + 1; i <= afterP1P1; ++i) {
            ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)new EtchedSlithEffect(), false);
            reflexive.addTarget((Target)new TargetPermanentOrPlayer(filter));
            game.fireReflexiveTriggeredAbility(reflexive, source);
        }
        return true;
    }

    static {
        filterPermanent.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter = new FilterPermanentOrPlayer("another target permanent or opponent", filterPermanent, (FilterPlayer)new FilterOpponent());
    }
}

