/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EtherWellEffect
extends OneShotEffect {
    EtherWellEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put target creature on top of its owner's library. If that creature is red, you may put it on the bottom of its owner's library instead.";
    }

    private EtherWellEffect(EtherWellEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtherWellEffect copy() {
        return new EtherWellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        if (permanent.getColor(game).isRed() && player.chooseUse(this.outcome, "Put " + permanent.getLogName() + " on the bottom of its owner's library?", source, game)) {
            player.putCardsOnBottomOfLibrary((Card)permanent, game, source);
            return true;
        }
        player.putCardsOnTopOfLibrary((Cards)new CardsImpl((Card)permanent), game, source, true);
        return true;
    }
}

