/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class EtherealArmor
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledEnchantmentPermanent("enchantment you control");
    private static final DynamicValue xValue = new PermanentsOnBattlefieldCount(filter);

    public EtherealArmor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(xValue, xValue, Duration.WhileOnBattlefield));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)FirstStrikeAbility.getInstance(), AttachmentType.AURA).setText("and has first strike"));
        this.addAbility(ability.addHint((Hint)new ValueHint("Enchantments you control", xValue)));
    }

    private EtherealArmor(EtherealArmor card) {
        super((CardImpl)card);
    }

    public EtherealArmor copy() {
        return new EtherealArmor(this);
    }
}

