/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class EtherswornCanonistWatcher
extends Watcher {
    private Set<UUID> castNonartifactSpell = new HashSet<UUID>();

    public EtherswornCanonistWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.getPlayerId() != null) {
            MageObject mageObject;
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell == null && (mageObject = game.getLastKnownInformation(event.getTargetId(), Zone.STACK)) instanceof Spell) {
                spell = (Spell)mageObject;
            }
            if (spell != null && !spell.isArtifact(game)) {
                this.castNonartifactSpell.add(event.getPlayerId());
            }
        }
    }

    public void reset() {
        this.castNonartifactSpell.clear();
    }

    public boolean castNonArtifactSpell(UUID playerId) {
        return this.castNonartifactSpell.contains(playerId);
    }
}

