/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ShuffleIntoLibrarySourceEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EtrataTheSilencerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    public EtrataTheSilencerEffect() {
        super(Outcome.Benefit);
    }

    private EtrataTheSilencerEffect(EtrataTheSilencerEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtrataTheSilencerEffect copy() {
        return new EtrataTheSilencerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent etrataTheSilencer;
        int cardsFound;
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(creature.getControllerId());
        if (controller == null || player == null) {
            return false;
        }
        controller.moveCards((Card)creature, Zone.EXILED, source, game);
        Card card = game.getCard(source.getFirstTarget());
        if (card != null) {
            card.addCounters(CounterType.HIT.createInstance(), source.getControllerId(), source, game);
        }
        if ((cardsFound = game.getExile().getCardsOwned(game, player.getId()).stream().filter(c -> c.getCounters(game).getCount(CounterType.HIT) > 0).mapToInt(x -> 1).sum()) >= 3) {
            player.lost(game);
        }
        if ((etrataTheSilencer = game.getPermanent(source.getSourceId())) != null && etrataTheSilencer.isPhasedIn()) {
            return new ShuffleIntoLibrarySourceEffect().apply(game, source);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }

    public String getText(Mode mode) {
        return "exile target creature that player controls and put a hit counter on that card. That player loses the game if they own three or more exiled cards with hit counters on them. {this}'s owner shuffles {this} into their library";
    }

    static {
        filter.add((Predicate)CounterType.HIT.getPredicate());
    }
}

