/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class EvelynTheCovetousWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> exiledMap = new HashMap<UUID, Set<MageObjectReference>>();
    private final Map<MageObjectReference, Set<UUID>> usedMap = new HashMap<MageObjectReference, Set<UUID>>();

    EvelynTheCovetousWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if ((event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED) && event.getApprovingObject() != null) {
            this.usedMap.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), x -> new HashSet()).add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.usedMap.clear();
    }

    static void addCards(UUID playerId, Cards cards, Game game) {
        Set set = ((EvelynTheCovetousWatcher)game.getState().getWatcher(EvelynTheCovetousWatcher.class)).exiledMap.computeIfAbsent(playerId, x -> new HashSet());
        cards.getCards(game).stream().map(card -> new MageObjectReference((MageObject)card, game)).forEach(set::add);
    }

    static boolean checkUsed(Ability source, Game game) {
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject == null) {
            return true;
        }
        return ((EvelynTheCovetousWatcher)game.getState().getWatcher(EvelynTheCovetousWatcher.class)).usedMap.getOrDefault(new MageObjectReference((MageObject)sourceObject, game), Collections.emptySet()).contains(source.getControllerId());
    }

    static boolean checkExile(UUID playerId, Card card, Game game, int offset) {
        return ((EvelynTheCovetousWatcher)game.getState().getWatcher(EvelynTheCovetousWatcher.class)).exiledMap.getOrDefault(playerId, Collections.emptySet()).stream().anyMatch(mor -> mor.refersTo((MageObject)card, game, offset));
    }
}

