/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EvraHalcyonWitnessEffect
extends OneShotEffect {
    EvraHalcyonWitnessEffect() {
        super(Outcome.GainLife);
        this.staticText = "Exchange your life total with {this}'s power";
    }

    private EvraHalcyonWitnessEffect(EvraHalcyonWitnessEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm;
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.isLifeTotalCanChange() && (perm = game.getPermanent(source.getSourceId())) != null && perm.isCreature(game)) {
            int amount = perm.getPower().getValue();
            int life = player.getLife();
            if (life == amount) {
                return false;
            }
            if (life < amount && !player.isCanGainLife()) {
                return false;
            }
            if (life > amount && !player.isCanLoseLife()) {
                return false;
            }
            player.setLife(amount, game, source);
            game.addEffect((ContinuousEffect)new SetBasePowerSourceEffect(life, Duration.Custom), source);
            return true;
        }
        return false;
    }

    public EvraHalcyonWitnessEffect copy() {
        return new EvraHalcyonWitnessEffect(this);
    }
}

