/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.FishToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ExoticPetsEffect
extends OneShotEffect {
    ExoticPetsEffect() {
        super(Outcome.Benefit);
        this.staticText = "create two 1/1 blue Fish creature tokens with \"This creature can't be blocked.\" Then for each kind of counter among creatures you control, put a counter of that kind on either of those tokens";
    }

    private ExoticPetsEffect(ExoticPetsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExoticPetsEffect copy() {
        return new ExoticPetsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FishToken token = new FishToken();
        token.putOntoBattlefield(2, game, source);
        List permanents = token.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        Set counterTypes = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().map(permanent -> permanent.getCounters(game)).map(HashMap::keySet).flatMap(Collection::stream).distinct().map(CounterType::findByName).collect(Collectors.toSet());
        if (counterTypes.isEmpty()) {
            return true;
        }
        if (permanents.size() == 1) {
            Permanent permanent2 = (Permanent)permanents.get(0);
            for (CounterType counterType : counterTypes) {
                permanent2.addCounters(counterType.createInstance(), source, game);
            }
            return true;
        }
        FilterPermanent filter = new FilterPermanent("creature");
        filter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        for (CounterType counterType : counterTypes) {
            target.clearChosen();
            target.withChooseHint("to add " + counterType.getArticle() + ' ' + counterType + " counter to");
            player.choose(Outcome.BoostCreature, (Target)target, source, game);
            Permanent permanent3 = game.getPermanent(target.getFirstTarget());
            if (permanent3 == null) continue;
            permanent3.addCounters(counterType.createInstance(), source, game);
        }
        return true;
    }
}

