/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.cards.CardSetInfo;
import mage.cards.SplitCard;
import mage.cards.e.ExplosionEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SpellAbilityType;
import mage.filter.FilterSpell;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.TargetSpell;
import mage.target.common.TargetAnyTarget;

public final class ExpansionExplosion
extends SplitCard {
    private static final FilterSpell filter = new FilterInstantOrSorcerySpell("instant or sorcery spell with mana value 4 or less");

    public ExpansionExplosion(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{U/R}{U/R}", "{X}{U}{U}{R}{R}", SpellAbilityType.SPLIT);
        this.getLeftHalfCard().getSpellAbility().addEffect((Effect)new CopyTargetStackObjectEffect());
        this.getLeftHalfCard().getSpellAbility().addTarget((Target)new TargetSpell(filter));
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)new ExplosionEffect());
        this.getRightHalfCard().getSpellAbility().addTarget(new TargetAnyTarget().withChooseHint("To deal damage"));
        this.getRightHalfCard().getSpellAbility().addTarget(new TargetPlayer().withChooseHint("To draw cards"));
    }

    private ExpansionExplosion(ExpansionExplosion card) {
        super((SplitCard)card);
    }

    public ExpansionExplosion copy() {
        return new ExpansionExplosion(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 5));
    }
}

