/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.designations.DesignationType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ExpelFromOrazcaEffect
extends OneShotEffect {
    ExpelFromOrazcaEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target nonland permanent to its owner's hand. If you have the city's blessing, you may put that permanent on top of its owner's library instead";
    }

    private ExpelFromOrazcaEffect(ExpelFromOrazcaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExpelFromOrazcaEffect copy() {
        return new ExpelFromOrazcaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetPermanent != null) {
                if (controller.hasDesignation(DesignationType.CITYS_BLESSING) && controller.chooseUse(this.outcome, "Put " + targetPermanent.getIdName() + " on top of its owner's library instead?", source, game)) {
                    controller.moveCards((Card)targetPermanent, Zone.LIBRARY, source, game);
                } else {
                    controller.moveCards((Card)targetPermanent, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

