/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ExpropriateEffect
extends OneShotEffect {
    ExpropriateEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Council's dilemma</i> &mdash; Starting with you, each player votes for time or money. For each time vote, take an extra turn after this one. For each money vote, choose a permanent owned by the voter and gain control of it";
    }

    private ExpropriateEffect(ExpropriateEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExpropriateEffect copy() {
        return new ExpropriateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Time (extra turn)", "Money (gain control)", Outcome.Detriment);
        vote.doVotes(source, game);
        int timeCount = vote.getVoteCount((Object)true);
        for (int i = 0; i < timeCount; ++i) {
            game.getState().getTurnMods().add(new TurnMod(source.getControllerId()).withExtraTurn());
        }
        if (vote.getVoteCount((Object)false) < 1) {
            return true;
        }
        ArrayList toSteal = new ArrayList();
        for (UUID playerId : vote.getVotedFor((Object)false)) {
            int moneyCount = vote.getVotes(playerId).stream().mapToInt(x -> x != false ? 0 : 1).sum();
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new ControllerIdPredicate(playerId));
            moneyCount = Math.min(game.getBattlefield().count(filter, source.getControllerId(), source, game), moneyCount);
            if (moneyCount == 0) continue;
            TargetPermanent target = new TargetPermanent(moneyCount, filter);
            target.withNotTarget(true);
            player.choose(Outcome.GainControl, (Target)target, source, game);
            target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEach(toSteal::add);
        }
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, source.getControllerId()).setTargetPointer((TargetPointer)new FixedTargets(toSteal, game)), source);
        return true;
    }
}

