/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ExquisiteArchangelEffect
extends ReplacementEffectImpl {
    ExquisiteArchangelEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would lose the game, instead exile {this} and your life total becomes equal to your starting life total";
    }

    private ExquisiteArchangelEffect(ExquisiteArchangelEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ExquisiteArchangelEffect copy() {
        return new ExquisiteArchangelEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            new ExileSourceEffect().apply(game, source);
            player.setLife(game.getStartingLife(), game, source);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOSES;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

