/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.e.ExterminatorMagmarchTriggeredAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.StackObjectCopyApplier;

class ExterminatorMagmarchEffect
extends OneShotEffect {
    ExterminatorMagmarchEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose one of those permanents. Copy that spell. The copy targets the chosen permanent";
    }

    private ExterminatorMagmarchEffect(ExterminatorMagmarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExterminatorMagmarchEffect copy() {
        return new ExterminatorMagmarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        UUID opponentId = (UUID)this.getValue(ExterminatorMagmarchTriggeredAbility.getKey());
        if (player == null || spell == null || opponentId == null) {
            return false;
        }
        FilterNonlandPermanent filter = StaticFilters.FILTER_OPPONENTS_PERMANENT_NON_LAND.copy();
        filter.add(Predicates.not((Predicate)new ControllerIdPredicate(opponentId)));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withChooseHint("to target with the copy");
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), false, 1, (StackObjectCopyApplier)new ExterminatorMagmarchApplier(permanent, game));
        return true;
    }

    private static class ExterminatorMagmarchApplier
    implements StackObjectCopyApplier {
        private final Iterator<MageObjectReferencePredicate> predicate;

        ExterminatorMagmarchApplier(Permanent permanent, Game game) {
            this.predicate = Arrays.asList(new MageObjectReferencePredicate((MageObject)permanent, game)).iterator();
        }

        public void modifySpell(StackObject stackObject, Game game) {
        }

        public MageObjectReferencePredicate getNextNewTargetType() {
            if (this.predicate.hasNext()) {
                return this.predicate.next();
            }
            return null;
        }
    }
}

