/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.Ownerable;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ExtraordinaryJourneyEffect
extends OneShotEffect {
    ExtraordinaryJourneyEffect() {
        super(Outcome.Neutral);
        this.staticText = "exile up to X target creatures. For each of those cards, its owner may play it for as long as it remains exiled";
    }

    private ExtraordinaryJourneyEffect(ExtraordinaryJourneyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExtraordinaryJourneyEffect copy() {
        return new ExtraordinaryJourneyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = ((Target)source.getTargets().get(0)).getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        OneShotEffect effect = new ExileTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(permanents, game));
        if (!effect.apply(game, source)) {
            return false;
        }
        game.processAction();
        Set cards = permanents.stream().map(Card::getMainCard).filter(Objects::nonNull).filter(card -> game.getState().getZone(card.getId()) == Zone.EXILED).collect(Collectors.toSet());
        Set owners = cards.stream().map(Ownerable::getOwnerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        for (Player owner : owners) {
            String exileZoneName = "Exile \u2014 Can be played by " + owner.getName();
            UUID exileZoneId = CardUtil.getExileZoneId((String)exileZoneName, (Game)game);
            ExileZone zone = game.getState().getExile().createZone(exileZoneId, exileZoneName);
            for (Card card2 : cards) {
                if (!card2.getOwnerId().equals(owner.getId())) continue;
                game.getExile().moveToAnotherZone(card2, game, zone);
                CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card2, (boolean)false, (Duration)Duration.Custom, (boolean)false, (UUID)card2.getOwnerId(), null);
            }
        }
        return true;
    }
}

