/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetPlayerOrPlaneswalker;

class ExuberantFirestokerTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power 5 or greater");

    public ExuberantFirestokerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2), true);
        this.addTarget((Target)new TargetPlayerOrPlaneswalker());
    }

    private ExuberantFirestokerTriggeredAbility(ExuberantFirestokerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ExuberantFirestokerTriggeredAbility copy() {
        return new ExuberantFirestokerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getPlayerId().equals(this.controllerId);
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getBattlefield().countAll((FilterPermanent)filter, this.controllerId, game) > 0;
    }

    public String getRule() {
        return "At the beginning of your end step, if you control a creature with power 5 or greater, you may have {this} deal 2 damage to target player or planeswalker.";
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 4));
    }
}

