/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.common.TargetNonlandPermanent;

class EyeOfDoomEffect
extends OneShotEffect {
    EyeOfDoomEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player chooses a nonland permanent and puts a doom counter on it";
    }

    private EyeOfDoomEffect(EyeOfDoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public EyeOfDoomEffect copy() {
        return new EyeOfDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Permanent> permanents = new HashMap<UUID, Permanent>();
        TargetNonlandPermanent target = new TargetNonlandPermanent();
        target.withNotTarget(true);
        PlayerList playerList = game.getPlayerList().copy();
        playerList.setCurrent((Object)game.getActivePlayerId());
        Player player = game.getPlayer(game.getActivePlayerId());
        do {
            Permanent permanent;
            target.clearChosen();
            if (player == null || !player.chooseTarget(this.outcome, (Target)target, source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null) continue;
            permanents.put(player.getId(), permanent);
            game.informPlayers(player.getLogName() + " chooses " + permanent.getName());
        } while ((player = playerList.getNext(game, false)) != null && !player.getId().equals(game.getActivePlayerId()));
        for (Map.Entry entry : permanents.entrySet()) {
            ((Permanent)entry.getValue()).addCounters(CounterType.DOOM.createInstance(), (UUID)entry.getKey(), source, game);
        }
        return true;
    }
}

