/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EyeOfSingularityETBEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    EyeOfSingularityETBEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy each permanent with the same name as another permanent, except for basic lands. They can't be regenerated";
    }

    private EyeOfSingularityETBEffect(EyeOfSingularityETBEffect effect) {
        super((OneShotEffect)effect);
    }

    public EyeOfSingularityETBEffect copy() {
        return new EyeOfSingularityETBEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<String, UUID> cardNames = new HashMap<String, UUID>();
        HashMap<Object, Integer> toDestroy = new HashMap<Object, Integer>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            String cardName = permanent.getName();
            if (cardNames.get(cardName) == null) {
                cardNames.put(cardName, permanent.getId());
                continue;
            }
            toDestroy.put(cardNames.get(cardName), 1);
            toDestroy.put(permanent.getId(), 1);
        }
        for (UUID id : toDestroy.keySet()) {
            Permanent permanent = game.getPermanent(id);
            if (permanent == null) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

