/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class EyeOfTheStormEffect1
extends OneShotEffect {
    public EyeOfTheStormEffect1() {
        super(Outcome.Neutral);
        this.staticText = "Whenever a player casts an instant or sorcery card, exile it. Then that player copies each instant or sorcery card exiled with {this}. For each copy, the player may cast the copy without paying its mana cost";
    }

    private EyeOfTheStormEffect1(EyeOfTheStormEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        boolean noLongerOnStack = false;
        if (spell == null) {
            spell = (Spell)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.STACK);
            noLongerOnStack = true;
        }
        Permanent eyeOfTheStorm = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (spell != null && eyeOfTheStorm != null) {
            Player spellController = game.getPlayer(spell.getControllerId());
            Card card = spell.getCard();
            if (spellController == null || card == null || !StaticFilters.FILTER_SPELL_AN_INSTANT_OR_SORCERY.match((Object)spell, game)) {
                return false;
            }
            if (!noLongerOnStack) {
                UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)eyeOfTheStorm.getZoneChangeCounter(game));
                spellController.moveCardsToExile((Card)spell, source, game, true, exileZoneId, eyeOfTheStorm.getIdName());
            }
            eyeOfTheStorm.imprint(card.getId(), game);
            if (eyeOfTheStorm.getImprinted() != null && !eyeOfTheStorm.getImprinted().isEmpty()) {
                CardsImpl copiedCards = new CardsImpl();
                for (UUID uuid : eyeOfTheStorm.getImprinted()) {
                    card = game.getCard(uuid);
                    if (card == null || game.getPlayer(card.getOwnerId()) == null) continue;
                    if (card instanceof SplitCard) {
                        copiedCards.add((Card)((SplitCard)card).getLeftHalfCard());
                        copiedCards.add((Card)((SplitCard)card).getRightHalfCard());
                        continue;
                    }
                    if (card instanceof ModalDoubleFacedCard) {
                        copiedCards.add((Card)((ModalDoubleFacedCard)card).getLeftHalfCard());
                        copiedCards.add((Card)((ModalDoubleFacedCard)card).getRightHalfCard());
                        continue;
                    }
                    copiedCards.add(card);
                }
                boolean continueCasting = true;
                while (spellController.canRespond() && continueCasting) {
                    Card cardToCopy;
                    boolean bl = continueCasting = copiedCards.size() > 1 && spellController.chooseUse(this.outcome, "Cast one of the copied cards without paying its mana cost?", source, game);
                    if (copiedCards.size() == 1) {
                        cardToCopy = (Card)copiedCards.getCards(game).iterator().next();
                    } else {
                        TargetCard target = new TargetCard(1, Zone.EXILED, new FilterCard("card to copy"));
                        spellController.choose(Outcome.Copy, (Cards)copiedCards, target, source, game);
                        cardToCopy = copiedCards.get(target.getFirstTarget(), game);
                        copiedCards.remove(cardToCopy);
                    }
                    if (cardToCopy == null) continue;
                    Card copy = game.copyCard(cardToCopy, source, source.getControllerId());
                    if (!spellController.chooseUse(this.outcome, "Cast " + copy.getIdName() + " without paying mana cost?", source, game)) continue;
                    game.getState().setValue("PlayFromNotOwnHandZone" + copy.getId(), (Object)Boolean.TRUE);
                    spellController.cast(spellController.chooseAbilityForCast(copy, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + copy.getId(), null);
                }
                return true;
            }
        }
        return false;
    }

    public EyeOfTheStormEffect1 copy() {
        return new EyeOfTheStormEffect1(this);
    }
}

