/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class EyeOfYawgmothEffect
extends OneShotEffect {
    EyeOfYawgmothEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal a number of cards from the top of your library equal to the sacrificed creature's power. Put one into your hand and exile the rest";
    }

    private EyeOfYawgmothEffect(EyeOfYawgmothEffect effect) {
        super((OneShotEffect)effect);
    }

    public EyeOfYawgmothEffect copy() {
        return new EyeOfYawgmothEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int power = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
            power = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getPower().getValue();
            break;
        }
        if (power > 0) {
            Card card;
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, power));
            controller.revealCards(source, (Cards)cards, game);
            TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put into your hand"));
            if (controller.choose(Outcome.DrawCard, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                controller.moveCards(card, Zone.HAND, source, game);
                cards.remove(card);
            }
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        }
        return true;
    }
}

