/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PrismaticBridgeEffect
extends OneShotEffect {
    PrismaticBridgeEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "reveal cards from the top of your library until you reveal a creature or planeswalker card. Put that card onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private PrismaticBridgeEffect(PrismaticBridgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrismaticBridgeEffect copy() {
        return new PrismaticBridgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl toReveal = new CardsImpl();
        Card toBattlefield = null;
        for (Card card : controller.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (!card.isCreature(game) && !card.isPlaneswalker(game)) continue;
            toBattlefield = card;
            break;
        }
        controller.revealCards(source, (Cards)toReveal, game);
        if (toBattlefield != null) {
            toReveal.remove(toBattlefield);
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
        }
        controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }
}

