/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.SpellAbilityType;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.stack.Spell;

class UrzasHotTubPredicate
implements Predicate<MageObject> {
    private final String referenceName;

    public UrzasHotTubPredicate(String referenceName) {
        this.referenceName = referenceName;
    }

    public boolean apply(MageObject input, Game game) {
        String name = input.getName();
        if (input instanceof SplitCard) {
            return this.sharesWordWithName(((SplitCard)input).getLeftHalfCard().getName()) || this.sharesWordWithName(((SplitCard)input).getRightHalfCard().getName());
        }
        if (input instanceof ModalDoubleFacedCard) {
            return this.sharesWordWithName(((ModalDoubleFacedCard)input).getLeftHalfCard().getName()) || this.sharesWordWithName(((ModalDoubleFacedCard)input).getRightHalfCard().getName());
        }
        if (input instanceof Spell && ((Spell)input).getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
            SplitCard card = (SplitCard)((Spell)input).getCard();
            return this.sharesWordWithName(card.getLeftHalfCard().getName()) || this.sharesWordWithName(card.getRightHalfCard().getName());
        }
        if (name.contains(" // ")) {
            String leftName = name.substring(0, name.indexOf(" // "));
            String rightName = name.substring(name.indexOf(" // ") + 4);
            return this.sharesWordWithName(leftName) || this.sharesWordWithName(rightName);
        }
        return this.sharesWordWithName(name);
    }

    private boolean sharesWordWithName(String str) {
        if (this.referenceName == null || this.referenceName.equals("")) {
            return false;
        }
        String[] arr = this.referenceName.split("\\s+");
        for (int i = 0; i < arr.length; ++i) {
            if (!str.contains(arr[i].replaceAll(",", ""))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "";
    }
}

