/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.f.FabledPassageUntapLandEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FabledPassageSearchForLandEffect
extends OneShotEffect {
    FabledPassageSearchForLandEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Search your library for a basic land card, put it onto the battlefield tapped, then shuffle";
    }

    private FabledPassageSearchForLandEffect(FabledPassageSearchForLandEffect effect) {
        super((OneShotEffect)effect);
    }

    public FabledPassageSearchForLandEffect copy() {
        return new FabledPassageSearchForLandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND_A);
        if (!player.searchLibrary(target, source, game)) {
            return false;
        }
        player.shuffleLibrary(source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        if (!player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null)) {
            return false;
        }
        for (Effect effect : source.getEffects()) {
            if (!(effect instanceof FabledPassageUntapLandEffect)) continue;
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            return true;
        }
        return true;
    }
}

